 ; Ŀ
 ;   Batr - batch relayer, does entities and block subentities.            
 ;   Copyright 2000, 2003, 2009 by Rocket Software Ltd.                    
 ;   Baseball, not pancakes.                                               
 ; 

 ; Ŀ
 ;   Subroutine Relb - relayer block subentities in the block tables.      
 ; 
 (DEFUN RELB (oldlay gnulay / reww blok enam entt num goon nxt)
  (setq reww t)
  (while (setq blok (tblnext "block" reww))           ; head entity from table
         (setq reww ())
         (grtext -2 (cdr (assoc 2 blok)))
         (setq enam (cdr (assoc -2 blok)))            ; first ename after head
         (while (and enam (setq entt (entget enam)))
                (setq num 0)
                (setq goon t)
                (while (and goon (setq nxt (nth num entt)))
                       (setq num (1+ num))
                       (if (and (= (car nxt) 8)
                                (= (strcase (cdr nxt)) oldlay))
                           (progn
                                (setq goon ())
                                (entmod (subst (cons 8 gnulay) nxt entt)))))
                (setq enam (entnext enam))))
 (princ))
 ; Ŀ
 ;   Relb end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Upblok - relayer attributes in block insertions.           
 ; 
 (DEFUN UPBLOK (oldlay gnulay / ss len num enam entt asoc8)
  (if (setq ss (ssget "X" (list (cons 0 "INSERT") (cons 66 1))))
      (progn
           (setq len (strcat "/" (itoa (sslength ss))))
           (setq num 0)           
           (while (setq enam (ssname ss num))
                  (grtext -2 (strcat (itoa (setq num (1+ num))) len))
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq
                                                     enam (entnext enam)))))))
                         (if (and (setq asoc8 (assoc 8 entt))
                                  (= (strcase (cdr asoc8)) oldlay))
                             (entmod (subst (cons 8 gnulay) asoc8 entt)))))))
 (princ))
 ; Ŀ
 ;   Upblok end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Batr.                                                      
 ; 
 (DEFUN BATR (oldlay newlay / ss enam num entt)
 ; Ŀ
 ;   If the new layer exists, move everything on the old layer to it,      
 ;   otherwise rename the old layer.                                       
 ; 
  (cond ((and (tblsearch "layer" oldlay)
              (null (tblsearch "layer" newlay)))
         (command "rename" "layer" oldlay newlay))
        ((and (tblsearch "layer" oldlay)
              (tblsearch "layer" newlay)
              (setq ss (ssget "X" (list (cons 8 oldlay)))))
         (setq num 0)
         (while (setq enam (ssname ss num))
                (setq num (1+ num))
                (setq entt (entget enam))
                (entmod (subst (cons 8 newlay) (assoc 8 entt) entt)))))
 ; Ŀ
 ;   Now go through the block tables, change any subentity on the old      
 ;   layer to the new one.                                                 
 ; 
  (relb oldlay newlay)
 ; Ŀ
 ;   Relayer attributes in block insertions - these are not automatically  
 ;   updated when the block tables are changed.                            
 ; 
  (upblok oldlay newlay)
 (princ))
 ; Ŀ
 ;   Batr end.                                                             
 ; 

 ; Ŀ
 ;   Batr.                                                                 
 ; 
 (DEFUN C:BATR (/ num sub oldlay newlay)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   This next line is the one to edit.                                    
 ; 
  (setq chlist '(("text" "e_text") ("text1" "e_text") ("text2" "e_text")))
  (setq num 0)
  (while (setq sub (nth num chlist))
         (setq num (1+ num))
         (setq oldlay (strcase (car sub)))
         (setq newlay (strcase (cadr sub)))
         (batr oldlay newlay))
 (princ))